package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class BusinessRetailerExportData implements Serializable {

    private static final long serialVersionUID = -6657008826355623391L;
    /**
     * 城市名称
     */
    @ExcelProperty("地区")
    private String name;

    /**
     * 当年目标-户数剔除取关注
     */
    @ExcelProperty({"当年目标","户数(剔除取关)"})
    private Long userCountNotFollowingTarget;
    /**
     * 当年目标-新增户数剔除取关注
     */
    @ExcelProperty({"当年目标","新增户数(剔除取关)"})
    private Long userIncreaseCountNotFollowingTarget;

    /**
     * 合计 -户数未剔除取关
     */
    @ExcelProperty({"合计","户数(未剔除)"})
    private Long userCount;

    /**
     * 合计 -户数剔除取消关
     */
    @ExcelProperty({"合计","户数(剔除取关)"})
    private Long userCountNotFollowing;

    /**
     * 合计-新增户数剔除取关注
     */
    @ExcelProperty({"合计","新增户数(剔除取关)"})
    private Long userIncreaseCountNotFollowing;

    /**
     * 目标进度
     */
    @ExcelProperty({"合计","目标进度"})
    private String targetProgress;

    /**
     * 邀请注册量-累计量
     */
    @ExcelProperty({"邀请注册","累计量"})
    private Long inviteAccumulativeCount;

    /**
     * 邀请注册量-单月量
     */
    @ExcelProperty({"邀请注册","单月"})
    private Long inviteSingleMonthCount;

    /**
     * 平和味道自主注册-累计量
     */
    @ExcelProperty({"平和味道累计注册","累计量"})
    private Long phwdAccumulativeCount;

    /**
     * 平和味道自主注册-单月量
     */
    @ExcelProperty({"平和味道累计注册","单月"})
    private Long phwdSingleMonthCount;

    /**
     * 自律小组引流 - 累计量
     */
    @ExcelProperty({"自律互助小组引流","累计量"})
    private Long selfDisciplineAccumulativeCount;

    /**
     * 自律小组引流 - 单月
     */
    @ExcelProperty({"自律互助小组引流","单月"})
    private Long selfDisciplineSingleMonthCount;

    /**
     * 小组联盟引流 -累计量
     */
    @ExcelProperty({"小组联盟引流","累计量"})
    private Long leagueAccumulativeCount;

    /**
     * 小组联盟引流 -单月
     */
    @ExcelProperty({"小组联盟引流","单月"})
    private Long leagueSingleMonthCount;

    /**
     * 获客-累计量
     */
    @ExcelProperty({"获客","累计量"})
    private Long getCustomersAccumulativeCount;

    /**
     * 获客-单月
     */
    @ExcelProperty({"获客","单月"})
    private Long getCustomersSingleMonthCount;

    /**
     * 扫码上柜-累计量
     */
    @ExcelProperty({"扫码上柜","累计量"})
    private Long scanCodeAccumulativeCount;

    /**
     * 扫码上柜-单月
     */
    @ExcelProperty({"扫码上柜","单月"})
    private Long scanCodeSingleMonthCount;

    /**
     * 其他活动-累计量
     */
    @ExcelProperty({"其他活动","累计量"})
    private Long othersAccumulativeCount;

    /**
     * 其他活动-单月
     */
    @ExcelProperty({"其他活动","单月"})
    private Long othersSingleMonthCount;
}
