package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author nongfu
 * @Date 2022/10/26 16:16
 */
@Data
public class ExportPlanDataReflowData implements Serializable {

    /**
     * 零售户入网数
     */
    @ExcelProperty("零售户入网数")
    private String saleAccessNum;
    /**
     * 消费者获客
     */
    @ExcelProperty("消费者获客")
    private String consumerAcquireNum;
    /**
     * 零售户活动交互
     */
    @ExcelProperty("零售户活动交互")
    private String saleJoinNum;
    /**
     * 消费者活动交互
     */
    @ExcelProperty("消费者活动交互")
    private String consumerJoinNum;
    /**
     * 推文宣传交互
     */
    @ExcelProperty("推文宣传交互")
    private String tweetJoinNum;
    /**
     * 策划推广费用
     */
    @ExcelProperty("策划推广费用")
    private String planExtendCost;
    /**
     * 市场营销烟合计(万元)
     */
    @ExcelProperty("市场营销烟合计(万元)")
    private String marketCigarettesCost;
    /**
     * 市场营销烟合计(条)
     */
    @ExcelProperty("市场营销烟合计(条)")
    private String marketCigarettesTotal;
    /**
     * 营销物资合计
     */
    @ExcelProperty("营销物资合计")
    private String marketGoodNum;
    /**
     * 快递合计(单数)
     */
    @ExcelProperty("快递合计(单数)")
    private String expressTotal;
    /**
     * 快递合计(万元)
     */
    @ExcelProperty("快递合计(万元)")
    private String expressCost;
    /**
     * 零售户交互人均单价
     */
    @ExcelProperty("零售户交互人均单价")
    private String saleJoinAvg;
    /**
     * 消费者交互人均单价
     */
    @ExcelProperty("消费者交互人均单价")
    private String consumerJoinAvg;
    /**
     * 推文交互人均单价
     */
    @ExcelProperty("推文交互人均单价")
    private String tweetJoinAvg;

    @ExcelProperty("活动时间")
    private String activityTime;


    @ExcelProperty("活动名称")
    private String activityName;


    @ExcelProperty("活动品规")
    private String regulateList;
    /**
     * 活动版块
     */
    @ExcelProperty("活动板块")
    private String templateName;

    /**
     * 部门
     */
    @ExcelProperty("部门")
    private String departmentList;

    /**
     * 活动负责人
     */
    @ExcelProperty("负责人")
    private String dutyPersonVoList;

}
