package cn.com.duiba.cloud.manage.service.api.model.dto.system;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 异步导出任务DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-17 18:02
 * @since 2.0.8
 **/
@Data
public class AsyncExportTaskDTO implements Serializable {
    private static final long serialVersionUID = -910393968395761233L;
    /**
     * 主键（任务id）
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务状态（1：处理中，2：处理成功，3：处理失败）
     */
    private Integer taskStatus;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建人userId
     */
    private Long createBy;

    /**
     * 导出文件地址
     */
    private String exportFileUrl;
}
