package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 通用启用、停用状态枚举
 *
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 11:35
 */
@Getter
@AllArgsConstructor
public enum EnableStateEnum implements IEnum<Integer> {

    /**
     * 0 停用
     * 1 启用
     */
    DISABLE(0, "停用"),
    ENABLE(1, "启用");

    private final Integer code;
    private final String desc;

    @Override
    public Integer getDbCode() {
        return code;
    }
}
