package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.CityDTO;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.stream.Collectors;

import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
public enum RegionDivideEnum {
    /**
     * 大区划分
     */
    NORTH_CHINA("华北",
            Lists.newArrayList(CityDTO.builder().cityName("北京市").code("110000").build()
                    ,CityDTO.builder().cityName("天津市").code("120000").build()
                    , CityDTO.builder().cityName("河北省").code("130000").build())),
    NORTHEAST("东北",
            Lists.newArrayList(CityDTO.builder().cityName("辽宁省").code("210000").build()
                    ,CityDTO.builder().cityName("吉林省").code("220000").build()
                    , CityDTO.builder().cityName("黑龙江省").code("230000").build())),
    EAST_CHINA("华东",
            Lists.newArrayList(CityDTO.builder().cityName("上海市").code("310000").build()
                    ,CityDTO.builder().cityName("江苏省").code("320000").build()
                    , CityDTO.builder().cityName("安徽省").code("340000").build()
                    , CityDTO.builder().cityName("山东省").code("370000").build())),
    SOUTH_CHINA("华南",
            Lists.newArrayList(CityDTO.builder().cityName("广东省").code("440000").build()
                    ,CityDTO.builder().cityName("广西壮族自治区").code("450000").build()
                    , CityDTO.builder().cityName("海南省").code("460000").build())),
    CENTRAL_SOUTH("中南",
            Lists.newArrayList(CityDTO.builder().cityName("福建省").code("350000").build()
                    ,CityDTO.builder().cityName("湖南省").code("430000").build()
                    , CityDTO.builder().cityName("江西省").code("360000").build()
                    , CityDTO.builder().cityName("湖北省").code("420000").build())),
    NORTHWEST("西北",
            Lists.newArrayList(CityDTO.builder().cityName("内蒙古自治区").code("150000").build()
                    ,CityDTO.builder().cityName("甘肃省").code("620000").build()
                    , CityDTO.builder().cityName("新疆维吾尔自治区").code("650000").build()
                    , CityDTO.builder().cityName("青海省").code("630000").build()
                    , CityDTO.builder().cityName("宁夏").code("640000").build())),
    SOUTHWEST("西南",
            Lists.newArrayList(CityDTO.builder().cityName("云南省").code("530000").build()
                    ,CityDTO.builder().cityName("贵州省").code("520000").build()
                    , CityDTO.builder().cityName("四川省").code("510000").build()
                    , CityDTO.builder().cityName("重庆市").code("500000").build())),
    CENTRAL_PLAIN("中原",
            Lists.newArrayList(CityDTO.builder().cityName("陕西省").code("610000").build()
                    ,CityDTO.builder().cityName("河南省").code("410000").build()
                    , CityDTO.builder().cityName("山西省").code("140000").build())),
            ;

    private static final ImmutableMap<String, RegionDivideEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, RegionDivideEnum> builder = ImmutableMap.builder();
        for (RegionDivideEnum item : RegionDivideEnum.values()) {
            builder = builder.put(item.getRegionName(), item);
        }
        INNER_MAP = builder.build();
    }

    private final String regionName;
    private final List<CityDTO> provinceName;

    RegionDivideEnum(String regionName, List<CityDTO> provinceName) {
        this.regionName = regionName;
        this.provinceName = provinceName;
    }

    public static RegionDivideEnum getByCode(String regionName) {
        return Objects.isNull(regionName) ? null : INNER_MAP.get(regionName);
    }

    public static RegionDivideEnum getByProvinceName(String provinceName) {
        for (Entry<String, RegionDivideEnum> entry : INNER_MAP.entrySet()) {
            RegionDivideEnum v = entry.getValue();
            List<CityDTO> provinceNames = v.getProvinceName();
            boolean b = provinceNames.stream().anyMatch(province-> province.getCityName().contains(provinceName));
            if (b) {
                return v;
            }
        }
        return null;
    }

    public static CityDTO getProvinceByProvinceName(String provinceName) {
        if (StrUtil.isBlank(provinceName)) {
            return null;
        }
        for (Entry<String, RegionDivideEnum> entry : INNER_MAP.entrySet()) {
            RegionDivideEnum v = entry.getValue();
            List<CityDTO> cityList = v.getProvinceName().stream()
                    .filter(province -> province.getCityName().contains(provinceName)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(cityList)) {
                return cityList.get(0);
            }
        }
        return new CityDTO();
    }

    public static List<RegionDivideEnum> getList(){
        return INNER_MAP.values().asList();
    }
}
