package cn.com.duiba.cloud.manage.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.user.AccountValidateDto;

import javax.validation.constraints.NotBlank;

/**
 * 钉钉开放平台api remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-18 17:42
 * @since 2.0.8
 **/
@AdvancedFeignClient
public interface RemoteDingTalkOpenApiService {
    /**
     * 通过sns临时授权码获取用户信息
     *
     * @param code sns临时授权码
     * @return 用户信息
     * @throws BizException 业务异常
     */
    AccountValidateDto getUserByCode(@NotBlank(message = "sns临时授权码不能为空") String code) throws BizException;
}
