package cn.com.duiba.cloud.manage.service.api.model.enums.system;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 员工账号类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-06 11:23
 * @since 0.0.3
 **/
@Getter
@AllArgsConstructor
public enum AccountTypeEnum implements IEnum<Integer> {
    /**
     * 外部账号
     */
    EXTERNAL_ACCOUNT(1, "外部账号"),

    /**
     * 企业员工
     */
    EMPLOYEES(2, "企业员工"),
    ;

    /**
     * 员工账号类型值
     */
    private Integer dbCode;

    /**
     * 员工账号类型文本
     */
    private String text;
}
