package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单明细
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/2/7
 */
@Getter
@Setter
@Builder
public class RemoteDeliOrderDetailParam implements Serializable {

    private static final long serialVersionUID = 29913606539163023L;
    /**
     * 供应商商品唯一标识
     */
    @NotBlank(message = "供应商sku不能为空")
    private String sku;

    /**
     * 平台商品唯一标识
     */
    @NotBlank(message = "平台sku不能为空")
    private String pxSku;

    /**
     * 采购数量
     */
    @NotNull(message = "采购数量不能为空")
    private Integer num;

    /**
     * 含税单价
     */
    @NotNull(message = "含税单价不能为空")
    private Double price;

    /**
     * 不含税单价
     */
    @NotNull(message = "不含税单价不能为空")
    private Double nakedPrice;

    /**
     * 税价
     */
    @NotNull(message = "税价不能为空")
    private Double taxPrice;

    /**
     * 税率，格式：0.17
     */
    @NotNull(message = "税率不能为空")
    private Double taxRate;
    
}
