package cn.com.duiba.cloud.manage.service.api.remoteservice.datav;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.ActivityCarryOutSituationDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.MarketOperationSituationDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.OperatingPlanDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.datav.plan.RateOfSurfaceDTO;

import java.util.List;

/**
 * datav，一地一策remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-30 16:50
 * @since 3.0.2
 **/
@AdvancedFeignClient
public interface RemoteAreaPlanService {
    /**
     * 市场运营情况数据
     *
     * @return 市场运营情况数据
     */
    MarketOperationSituationDTO getMarketOperationSituationData();

    /**
     * 活动开展情况数据
     *
     * @return 活动开展情况数据
     */
    List<ActivityCarryOutSituationDTO> getActivityCarryOutSituationData();


    /**
     * 两面两率
     *
     * @return 两面两率
     */
    RateOfSurfaceDTO getRateOfSurface();

    /**
     * 运营计划
     *
     * @return 运营计划数据
     */
    List<OperatingPlanDTO> getOperatingPlan();

    /**
     * 异常补数据
     */
    void abnormalComplementData();
}
