package cn.com.duiba.cloud.manage.service.api.model.dto.plan;

import cn.com.duiba.cloud.manage.service.api.model.dto.elasticsearch.RemoteEsBaseDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Date 2022/9/13 18:04
 * @Author LuHui
 */
@Data
public class RemoteEsPlanDto extends RemoteEsBaseDto{
    private static final long serialVersionUID = -5717614999073617480L;

    /**
     * 活动类型
     */
    private Integer activityType;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动开始时间
     */
    private Date actStartTime;
    /**
     * 活动结束时间
     */
    private Date actEndTime;
    /**
     * 活动品规
     */
    private List<RemoteRegulateDto> regulateList;
    /**
     * 活动板块
     */
    private Long activityTemplate;
    /**
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.plan.PlanModelEnum
     * 活动模版类型 活动模版类型 0:使用已有 1:定制开发
     */
    private Integer actModelType;

    /**
     * 活动模版
     */
    private String activityModelName;
    /**
     * 责任人列表
     */
    private List<RemoteDutyPersonDto> dutyPersonList;
    /**
     * 活动市场
     */
    private String activityMarket;
    /**
     * 部门列表
     */
    private List<RemoteDepartmentDto> departmentList;
}
