package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description
 * @Date 2022/9/9 17:20
 * @Author LuHui
 */
public enum PlanStatusEnum {
    WAIT_CONFIRM(0, "待确认"),
    ALREADY_CONFIRM(1, "已确认"),
    PREPARING(2, "筹备中"),
    PREPARE_COMPLETE(3, "筹备完成"),
    BEGINNING(4, "进行中"),
    END(5, "已结束"),
    CLOSE(6, "已关闭"),
    ;


    private Integer code;

    private String desc;

    PlanStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PlanStatusEnum getPlanStatusByCode(Integer code){
        return Stream.of(PlanStatusEnum.values()).filter(x -> Objects.equals(code, x.getCode())).findFirst().orElse(null);
    }
}
