package cn.com.duiba.cloud.manage.service.api.remoteservice.plan;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.RemotePlanTemplateDto;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemotePlanTemplateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemotePlanTemplateQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.RemotePlanTemplateRemoveParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description
 * @Date 2022/9/14 09:56
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemotePlanTemplateService {

    /**
     * 分页查询活动模版
     * @param remotePlanTemplateQueryParam
     * @return
     */
    PageResponse<RemotePlanTemplateDto> pageList(RemotePlanTemplateQueryParam remotePlanTemplateQueryParam) throws BizException;

    /**
     * 查看详情
     * @param id
     * @return
     */
    RemotePlanTemplateDto detail(Long id) throws BizException;

    /**
     * 创建活动模版
     * @param remotePlanTemplateParam
     * @return
     */
    Long create(RemotePlanTemplateParam remotePlanTemplateParam) throws BizException;

    /**
     * 编辑活动模版
     * @param remotePlanTemplateParam
     * @return
     */
    Boolean edit(RemotePlanTemplateParam remotePlanTemplateParam) throws BizException;

    /**
     * 移动
     * @param remotePlanTemplateRemoveParam
     * @return
     */
    Boolean remove(RemotePlanTemplateRemoveParam remotePlanTemplateRemoveParam) throws BizException;
}
