package cn.com.duiba.cloud.manage.service.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.TagValueUserDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.ZYTagValueDto;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteAddTagValueParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteCancelAllConnectParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteDelTagValueParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteQueryConnectParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteTagUserListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteTagValuePageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.value.RemoteUpdateTagValueParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/2
 */
@AdvancedFeignClient
public interface RemoteZYTagValueService {


    /**
     * 增加标签值
     * @param param
     * @return
     */
    Long addTagValue(RemoteAddTagValueParam param) throws BizException;

    /**
     * 更新标签值
     * @param param
     * @return
     */
    Boolean updateTagValue(RemoteUpdateTagValueParam param) throws BizException;

    /**
     * 删除标签值
     * @param param
     * @return
     */
    Boolean delTagValue(RemoteDelTagValueParam param);

    /**
     * 查询标签值列表
     * @param param
     * @return
     */
    PageResponse<ZYTagValueDto> queryList(RemoteTagValuePageQueryParam param);


    /**
     * 用户打/取消标签
     * @param param
     * @return
     */
    Boolean tagUserList(RemoteTagUserListParam param);


    /**
     * 取消所有用户关联
     * @param param
     * @return
     */
    Boolean cancelAllConnect(RemoteCancelAllConnectParam param);

    /**
     * 查询关联
     * @param param
     * @return
     */
    List<TagValueUserDto> queryConnectList(RemoteQueryConnectParam param);

    /**
     * 根据名称查询
     * @param name
     * @return
     */
    List<ZYTagValueDto> queryByNamePrefix(String name);

    /**
     * 根据id列表查询标签值
     * @param valueIdList
     * @param isDelete 能否查看被删除的
     * @return
     */
    List<ZYTagValueDto> queryByIdList(List<Long> valueIdList,Boolean isDelete);

    /**
     * 查询用户已关联的标签
     * @param userIdList 用户id list
     * @return List<TagValueUserDto>
     */
    List<TagValueUserDto> queryByUserIdList(List<Long> userIdList);

    /**
     * 根据id列表查询用户关联的标签
     * @param valueIdList 标签id list
     * @return List<TagValueUserDto>
     */
    List<TagValueUserDto> queryConnectByIdList(List<Long> valueIdList);
}
