/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.user.server.api.request;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerCookieDTO;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerDTO;
import cn.com.duiba.user.server.api.dto.consumer.TimeBasedRollingKeyDTO;
import cn.com.duiba.user.server.api.request.KmsClient;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaConsumerCookieClient {
    private static final Logger log = LoggerFactory.getLogger(DuibaConsumerCookieClient.class);
    protected static final String CONSUMER_WDATA4_COOKIE = "zy_wdata4";
    protected static final String LOGIN_TIME_COOKIE = "zy_w_ts";
    private final KmsClient kmsClient;

    public DuibaConsumerCookieClient(KmsClient kmsClient) {
        this.kmsClient = kmsClient;
    }

    public ConsumerCookieDTO getConsumerCookieDto(HttpServletRequest request) throws BizException {
        String userJson;
        String wdata4 = RequestTool.getCookie((HttpServletRequest)request, (String)CONSUMER_WDATA4_COOKIE);
        if (wdata4 == null || wdata4.isEmpty()) {
            return null;
        }
        long ts = NumberUtils.parseLong((String)RequestTool.getCookie((HttpServletRequest)request, (String)LOGIN_TIME_COOKIE), (long)-1L);
        if (ts == -1L || !this.isValidTime(ts)) {
            return null;
        }
        TimeBasedRollingKeyDTO tbrk = this.getTimeBasedRollingKey(ts);
        log.info("\u767b\u9646\u62e6\u622a\u5668:tbrk:{},ts:{}", (Object)JSON.toJSONString((Object)tbrk), (Object)ts);
        try {
            userJson = this.decrypt(wdata4, tbrk);
        }
        catch (Exception e) {
            log.warn("\u767b\u5f55\u62e6\u622a\uff0ccookie\u89e3\u6790\u5f02\u5e38, wdata4:{}, ts:{}", new Object[]{wdata4, ts, e});
            throw new BizException("\u767b\u5f55\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        ConsumerCookieDTO c = (ConsumerCookieDTO)JSON.parseObject((String)userJson, ConsumerCookieDTO.class);
        if (!this.isValidTime(c.getTime())) {
            return null;
        }
        return c;
    }

    public ConsumerCookieDTO injectConsumerInfoIntoCookie(ConsumerDTO tbConsumerDto, HttpServletResponse response) {
        long loginTime = System.currentTimeMillis();
        ConsumerCookieDTO cookieDto = this.makeConsumerCookieDto(tbConsumerDto, loginTime);
        String userJson = JSON.toJSONString((Object)cookieDto);
        TimeBasedRollingKeyDTO tbrk = this.getTimeBasedRollingKey(loginTime);
        String userCookieVal = this.encrypt(userJson, tbrk);
        log.info("\u767b\u9646\u62e6\u622a\u5668:tbrk:{},ts:{}", (Object)JSON.toJSONString((Object)tbrk), (Object)loginTime);
        Cookie userCookie = new Cookie(CONSUMER_WDATA4_COOKIE, userCookieVal);
        userCookie.setHttpOnly(true);
        userCookie.setPath("/");
        response.addCookie(userCookie);
        String loginTimeStr = String.valueOf(loginTime);
        Cookie tsCookie = new Cookie(LOGIN_TIME_COOKIE, loginTimeStr);
        tsCookie.setHttpOnly(true);
        tsCookie.setPath("/");
        response.addCookie(tsCookie);
        return cookieDto;
    }

    private boolean isValidTime(long loginTime) {
        long now = System.currentTimeMillis();
        return loginTime > now - 86400000L && loginTime < now + 300000L;
    }

    private TimeBasedRollingKeyDTO getTimeBasedRollingKey(long ts) {
        return this.kmsClient.getCachedTimeBasedRollingKey(ts);
    }

    public String encrypt(String srcData, TimeBasedRollingKeyDTO keyDto) {
        if (keyDto == null) {
            throw new NullPointerException("keyDto must not be null");
        }
        return SecurityUtils.encode2StringByBase64((byte[])SecurityUtils.encodeByAes((String)srcData, (String)keyDto.getSecretKey()));
    }

    public String decrypt(String ciphertext, TimeBasedRollingKeyDTO keyDto) {
        if (keyDto == null) {
            throw new NullPointerException("keyDto must not be null");
        }
        return new String(SecurityUtils.decodeByAes((byte[])SecurityUtils.decodeBase64((String)ciphertext), (String)keyDto.getSecretKey()), Charset.forName("UTF-8"));
    }

    private ConsumerCookieDTO makeConsumerCookieDto(ConsumerDTO tbConsumerDto, long loginTime) {
        if (tbConsumerDto.getId() == null) {
            throw new IllegalArgumentException("consumer's id must not be null");
        }
        if (tbConsumerDto.getPartnerUserId() == null) {
            throw new IllegalArgumentException("consumer's partnerUserId must not be null");
        }
        ConsumerCookieDTO cookieDto = new ConsumerCookieDTO();
        cookieDto.setCid(tbConsumerDto.getId());
        cookieDto.setPartnerUserId(tbConsumerDto.getPartnerUserId());
        cookieDto.setTime(loginTime);
        cookieDto.setUnionId(tbConsumerDto.getUnionId());
        cookieDto.setType(tbConsumerDto.getUserType());
        return cookieDto;
    }
}

