package cn.com.duiba.user.server.api.constant.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;


/**
 * 订阅枚举
 *
 * @author zouweixiang
 * @date 2021/10/14
 */
@Getter
public enum SubscribeEnum {

    /**
     * 用户关注状态
     */
    SUBSCRIBE(1, "关注"),

    /**
     * 退订
     */
    UNSUBSCRIBE(0, "未关注"),
    ;

    private Integer type;

    private String desc;

    SubscribeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, SubscribeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SubscribeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static SubscribeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }


}
