package cn.com.duiba.user.server.api.constant.enums.tag;

import java.util.Objects;

/**
 * @author xiaotian
 * @ClassName TagTypeEnum.java
 * @createTime 2021年11月08日 16:39:00
 * @Description
 */
public enum TagTypeEnum {

    WECHAT(1,"微信标签"),
    LOCAL(2,"本地标签"),
    ;
    private Integer code;

    private String desc;

    TagTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Boolean isWechatTag(Integer tagType){
        return Objects.nonNull(tagType) && WECHAT.getCode().equals(tagType);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
