package cn.com.duiba.user.server.api.dto.geo;

import java.io.Serializable;
import java.util.Optional;

/**
 * @author xiaotian
 */
public class IpAreaDto implements Serializable{

    private static final long serialVersionUID = 5800093655984506917L;

    private String ip;

    private String country;
    private String region;
    private String city;

    private String isp;

    /**
     * Only if international is true,the cityCode has value
     */
    private String cityCode;
    private Boolean international;
    /**
     * 是否是内网地址
     */
    private Boolean isLanIp;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getIsp() {
        return isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }


    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Boolean getInternational() {
        return Optional.ofNullable(international).orElse(true);
    }

    public void setInternational(Boolean international) {
        this.international = international;
    }

    public Boolean getLanIp() {
        return isLanIp;
    }

    public void setLanIp(Boolean lanIp) {
        isLanIp = lanIp;
    }
}
