package cn.com.duiba.user.server.api.constant.enums.exception;

/**
 * 错误代码
 *
 * @author zouweixiang
 * @date 2021/11/25
 */
public enum ErrorCode {

    /**
     * 状态码
     */
    RERROR("999999999", "未登录，请先登录"),
    NOT_LOGIN("1000000012", "未登录，请先登录"),
    TAG_NOT_EXIST("100000001","标签不存在"),
    TAG_ALREADY_DELETE("100000002","标签已删除"),
    TAG_GROUP_NOT_EXIST("100000003","标签组不存在"),
    TAG_GROUP_ALREADY_DELETE("100000004","标签组已删除"),
    TAG_GROUP_EXIST("100000005","存在同名标签组"),
    TAG_GROUP_ADD_ERROR("100000006","标签组创建失败"),
    TAG_EXIST("100000007","存在同名标签"),
    TAG_WECHAT_ADD_ERROR("100000008","微信标签创建失败"),
    TAG_WECHAT_GROUP_NAME_CAN_NOT_DEL("100000009","微信标签组不能删除"),
    TAG_WECHAT_USER_UNSUBSCRIBE("100000010","微信标签添加失败，用户未关注公众号")
    ;


    private String code;

    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
