package cn.com.duiba.user.server.api.constant.enums;

import lombok.Getter;

/**
 * 消费者类型的枚举
 *
 * @author zouweixiang
 * @date 2021/11/25
 */
@Getter
public enum ConsumerTypeEnum {

	/**
	 * 消费者
	 */
	CONSUMER(1, "消费者"),

	/**
	 * 零售户
	 */
	RETAIL(2, "零售户"),
	;


	/**
	 * 枚举值
	 */
	private final int code;

	/**
	 * 枚举描述
	 */
	private final String desc;


	ConsumerTypeEnum(final int code, final String desc) {
		this.code = code;
		this.desc = desc;
	}

}
