package cn.com.duiba.user.server.api.constant.enums.tag;

import lombok.Getter;

/**
 * 微信错误枚举，提示转换枚举
 *
 * @author xiaotian
 * @date 2021/11/25
 */
@Getter
public enum WxTagErrorCodeEnum {

	TAG_WECHAT_USER_UNSUBSCRIBE(50005, "微信标签添加失败，用户未关注公众号"),

	TAG_REMOVE(45159, "操作失败，微信标签已被删除"),
	;


	/**
	 * 枚举值
	 */
	private final Integer code;

	/**
	 * 枚举描述
	 */
	private final String desc;


	WxTagErrorCodeEnum(final int code, final String desc) {
		this.code = code;
		this.desc = desc;
	}


	public static WxTagErrorCodeEnum getByCode(Integer code){
		for (WxTagErrorCodeEnum wxTagErrorCodeEnum : WxTagErrorCodeEnum.values()) {
			if(wxTagErrorCodeEnum.getCode().equals(code)){
				return wxTagErrorCodeEnum;
			}
        }
		return null;
	}
}
