package cn.com.duiba.user.server.api.dto.consumer;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;


/**
 * 按时间滚动的密钥, 数据库实体类
 *
 * @author zouweixiang
 * @date 2021/11/24
 */
@Data
public class TimeBasedKeyDTO implements Serializable {

    private static final long serialVersionUID = 5342615925328196391L;

    private Long id;
    /**
     * 密钥生效日期,格式yyyy-MM-dd
     */
    @NotBlank(message = "密钥日期不能为空")
    private String validDay;
    /**
     * 密钥
     */
    @NotBlank(message = "密钥不能为空")
    private String secretKey;


    /**
     * 判断指定的时间戳是否落在本密钥的有效期内
     * @param timestamp
     * @return
     */
    public boolean isMatch(long timestamp){
        return org.apache.commons.lang3.time.DateUtils.isSameDay(new Date(timestamp), DateUtils.getDayDate(validDay));
    }
}
