package cn.com.duiba.user.server.api.dto.consumer;

import java.io.Serializable;


/**
 * 只在某个时间段适用的密钥
 *
 * @author zouweixiang
 * @date 2021/11/23
 */
public class TimeBasedRollingKeyDTO implements Serializable {

    private static final long serialVersionUID = -9043374493478890015L;

    /**
     * 密钥适用的开始时间（包含）
     */
    private long startTimeMillis;
    /**
     * 密钥适用的结束时间（不包含）
     */
    private long endTimeMillis;

    /**
     * 密钥
     */
    private String secretKey;

    public long getStartTimeMillis() {
        return startTimeMillis;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public long getEndTimeMillis() {
        return endTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }


    /**
     * 判断指定的时间戳是否落在本密钥的有效期内
     * @param timestamp
     * @return
     */
    public boolean isMatch(long timestamp){
        return startTimeMillis <= timestamp && timestamp < endTimeMillis;
    }

    @Override
    public String toString(){
        return "secretKey:" + secretKey + ",startTimeMillis:" + startTimeMillis;
    }
}
