package cn.com.duiba.user.server.api.param.consumer;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 客户留言分页请求
 *
 * @author zouweixiang
 * @date 2021/12/01
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteConsumerMessageParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -1033480992446411936L;

    /**
     * 发送开始时间
     */
    private Date sendStartTime;

    /**
     * 发送结束时间
     */
    private Date sendEndTime;

    /**
     * 消费者id
     */
    @NotNull(message = "客户id不能为空")
    private Long consumerId;

    private String openId;
}
