package cn.com.duiba.user.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerMessageDTO;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerMessagePageDTO;
import cn.com.duiba.user.server.api.param.consumer.RemoteConsumerMessageParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 客户信息服务
 *
 * @author zouweixiang
 * @date 2021/11/29
 */
@AdvancedFeignClient
public interface RemoteConsumerMessageService {
    /**
     * 保存客户留言
     *
     * @param consumerMessageDTO 消费者信息dto
     */
    void saveConsumerMessage(ConsumerMessageDTO consumerMessageDTO);


    /**
     * 分页查询客户留言
     *
     * @param remoteConsumerMessageParam 客户留言
     * @return {@link PageResponse<ConsumerMessagePageDTO>}
     */
    PageResponse<ConsumerMessagePageDTO> findConsumerMessageByPage(RemoteConsumerMessageParam remoteConsumerMessageParam);

    /**
     * 查询客户们的留言
     * @param openIdList 客户id list
     * @return List<ConsumerMessagePageDTO>
     */
    List<ConsumerMessagePageDTO> findConsumerMessageList(List<String> openIdList);
}
