package cn.com.duiba.user.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.consumer.AddTimeBasedKeyDTO;
import cn.com.duiba.user.server.api.dto.consumer.TimeBaseRecentlyDTO;
import cn.com.duiba.user.server.api.dto.consumer.TimeBasedKeyDTO;
import cn.com.duiba.user.server.api.param.consumer.RemoteTimeBaseParam;
import cn.com.duiba.wolf.entity.JsonResult;

import java.util.List;

/**
 * 按时间滚动密钥服务
 *
 * @author zouweixiang
 * @date 2021/11/24
 */
@AdvancedFeignClient
public interface RemoteTimeBasedKeyService {

    /**
     * 找到的条件
     *
     * @param remoteTimeBaseParam
     * @return {@link TimeBasedKeyDTO}
     */
    TimeBasedKeyDTO findByCondition(RemoteTimeBaseParam remoteTimeBaseParam);

    /**
     * 发现最近
     *
     * @param remoteTimeBaseParam
     * @return {@link List<TimeBasedKeyDTO>}
     */
    TimeBaseRecentlyDTO findRecently(RemoteTimeBaseParam remoteTimeBaseParam);

    /**
     * 添加基于时间的关键
     *
     * @param e e
     * @return {@link Integer}
     */
    AddTimeBasedKeyDTO addTimeBasedKey(TimeBasedKeyDTO e);
}
