package cn.com.duiba.user.server.api.remoteservice.sensword;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.sensword.SensitiveWordDto;

import java.util.Set;

/**
 * Created by sunchangji on 2018/11/26.
 */
@AdvancedFeignClient
public interface RemoteSensitiveWordService {

	/**
	 * 单机限流200qps
	 * 检查是否给的字符串包含敏感词信息, 返回的SensitiveWordDto只会包含一个敏感词
	 *
	 * @param checkStr 需要检查的字符串
	 * @return SensitiveWordDto
	 */
	SensitiveWordDto checkContainSenWord(String checkStr) throws BizException;

	/**
	 * 获取匹配到的所有敏感词, 如果没有，则返回空Set
	 *
	 * @param checkStr 需要检查的字符串
	 * @return
	 */
	Set<String> getSensitiveWords(String checkStr);

	/**
	 * 过滤敏感词，并把敏感词替换为指定字符
	 *
	 * @param checkStr 被匹配的语句
	 * @param replaceChar 替换字符, 比如'*'
	 * @return 过滤后的字符串
	 */
	String filter(String checkStr, char replaceChar);

	/**
	 * 高亮敏感词
	 * @param checkStr 被匹配的语句
	 * @param template 敏感词替换模板，模板中必须包含一个%s，比如
	 *                    <xmp>
	 *                        <font color='red'>%s</font>
	 *                    </xmp>
	 * @return 返回html高亮敏感词
	 */
	String highlight(String checkStr, String template);

}
