package cn.com.duiba.user.server.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 用户上下文
 *
 * @author zouweixiang
 * @date 2021/11/24
 */
@Data
public class UserContext {

    private static ThreadLocal<UserInfo> userLocal = new InheritableThreadLocal<>();


    /**
     * <strong>！！！禁止调用此方法！！！！do NOT use this method!</strong>
     * 清除数据，防止内存泄露。
     */
    public static void clean() {
        userLocal.remove();
    }

    public static void setUserContext(UserInfo userContext) {
        userLocal.set(userContext);
    }

    /**
     * 得到用户上下文
     *
     * @return {@link UserInfo}
     */
    public static UserInfo getUserContext() {
        return userLocal.get();
    }


    /**
     * 用户信息
     *
     * @author zouweixiang
     * @date 2021/12/01
     */
    @Data
    public static class UserInfo implements Serializable {

        private static final long serialVersionUID = -103926502816346273L;
        /**
         * 用户id
         */
        private Long cid;

        /**
         * uid
         */
        private String uid;

        /**
         * 开放id
         */
        private String unionId;

        /**
         * 用户类型
         */
        private Integer type;
        /**
         * 登录时间
         */
        private Long loginTime;
    }


}
