package cn.com.duiba.wechat.server.api.constant;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复
 *
 * @author zouweixiang
 * @date 2021/09/12
 */
public enum RedisKeyFactory {

    /**
     * 三方平台token缓存分布式锁key
     **/
    COMPONENT_LOCK,
    /**
     * 三方平台token key
     */
    COMPONENT_TOKEN,

    /**
     * 三方平台票据
     */
    COMPONENT_TICKET,
    /**微信用户缓存**/
    WX_USER,

    /****/
    MQ_USER,

    /**
     * ACCESS_TOKEN key
     */
    ACCESS_TOKEN,

    /**
     * 消息模板
     */
    MESSAGE_TEMPLATE,

    /**
     * 公众号菜单
     */
    WX_MENU,
    ;

    /**
     * 应用名称
     */
    private static final String SPACE = "WECHAT";

    /**
     * 得到锁定键
     *
     * @param param 参数
     * @return {@link String}
     */
    public String getLockKey(String param) {
        return getRedisKey(param) + ":lock";
    }

    /**
     * 获取缓存key
     *
     * @param param 参数
     * @return {@link String}
     */
    public String getRedisKey(String param) {
        return toString() + param;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

}