package cn.com.duiba.wechat.server.api.constant;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

/**
 * @author xuanhongjian
 */
public class SceneParamConstants {

    /**
     * 存放每个场景的可用变量
     */
    private static final ImmutableMap<Integer, Map<String, String>> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, Map<String, String>> builder = ImmutableMap.builder();
        Map<String, String> prizeNotice = Maps.newHashMap();
        prizeNotice.put("{user}", "getUser");
        prizeNotice.put("{phone}", "getPhone");
        prizeNotice.put("{activity}", "getActivityName");
        prizeNotice.put("{award}", "getAwardName");
        prizeNotice.put("{award_time}", "getAwardTime");
        prizeNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.PRIZE_NOTICE.getCode(), prizeNotice);
        Map<String, String> expiredNotice = Maps.newHashMap();
        expiredNotice.put("{user}", "getUser");
        expiredNotice.put("{phone}", "getPhone");
        expiredNotice.put("{activity}", "getActivityName");
        expiredNotice.put("{award}", "getAwardName");
        expiredNotice.put("{award_time}", "getAwardTime");
        expiredNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.EXPIRED_NOTICE.getCode(), expiredNotice);
        Map<String, String> shipNotice = Maps.newHashMap();
        shipNotice.put("{user}", "getUser");
        shipNotice.put("{phone}", "getPhone");
        shipNotice.put("{activity}", "getActivityName");
        shipNotice.put("{award}", "getAwardName");
        shipNotice.put("{award_time}", "getAwardTime");
        shipNotice.put("{award_deadline}", "getAwardDeadline");
        shipNotice.put("{express_company}", "getExpressCompany");
        shipNotice.put("{express_num}", "getExpressNum");
        shipNotice.put("{order_id}", "getOrderId");
        builder.put(PushScenesEnum.SHIP_NOTICE.getCode(), shipNotice);
        INNER_MAP = builder.build();
    }

    private static String getMethodName(Integer code, String paramName) {
        Map<String, String> map = INNER_MAP.get(code);
        return MapUtils.isEmpty(map) ? null : map.get(paramName);
    }
}
