package cn.com.duiba.wechat.server.api.constant.enums;

import lombok.Getter;

/**
 * 微信推送信息类型枚举
 *
 * @author zouweixiang
 * @date 2021/11/23
 */
@Getter
public enum TicketPushTypeEnum {

	/**
	 * 验证凭据组件
	 */
	COMPONENT_VERIFY_TICKET(1, "component_verify_ticket"),

	/**
	 * 未授权
	 */
	UNAUTHORIZED(2, "unauthorized"),

	/**
	 * 已授权
	 */
	AUTHORIZED(3, "authorized"),

	/**
	 * 授权更新
	 */
	UPDATE_AUTHORIZED(4, "updateauthorized");


	/**
	 * 枚举值
	 */
	private final int code;

	/**
	 * 枚举描述
	 */
	private final String desc;


	TicketPushTypeEnum(final int code, final String desc) {
		this.code = code;
		this.desc = desc;
	}

}
