package cn.com.duiba.wechat.server.api.constant.enums;

import lombok.Getter;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/1/12
 */
@Getter
public enum WxErrorCodeEnum {
    E_10000(-10000,"错误码暂时找不到对应"),
    //请求发生未知错误，可能已经成功，不可盲目重试
    E_8(-8,"请求发送异常"),
    //确认请求未发出。可选择重试
    E_7(-7,"httpclient 发送请求时错误"),
    //微信有些功能是下限不可用的，活着API中功能未开放
    E_6(-6,"功能下线"),
    E_5(-5,"参数错误"),
    //socket超时，但请求已经发出
    E_4(-4,"请求没有回复"),
    //特殊情况
    E_3(-3,"配置不发送消息"),
    E_2(-2,"参数为空"),
    E_1(-1,"系统繁忙，请开发者重试"),
    E0(0,"请求成功"),
    E40001(40001,"获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口"),
    E40002(40002,"不合法的凭证类型"),
    E40003(40003,"不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID"),
    E40004(40004,"不合法的媒体文件类型"),
    E40005(40005,"不合法的文件类型"),
    E40006(40006,"不合法的文件大小"),
    E40007(40007,"不合法的媒体文件 id"),
    E40008(40008,"不合法的消息类型"),
    E40009(40009,"不合法的图片文件大小"),
    E40010(40010,"不合法的语音文件大小"),
    E40011(40011,"不合法的视频文件大小"),
    E40012(40012,"不合法的缩略图文件大小"),
    E40013(40013,"不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写"),
    E40014(40014,"不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口"),
    E40015(40015,"不合法的菜单类型"),
    E40016(40016,"不合法的按钮个数"),
    E40017(40017,"不合法的按钮类型"),
    E40018(40018,"不合法的按钮名字长度"),
    E40019(40019,"不合法的按钮 KEY 长度"),
    E40020(40020,"不合法的按钮 URL 长度"),
    E40021(40021,"不合法的菜单版本号"),
    E40022(40022,"不合法的子菜单级数"),
    E40023(40023,"不合法的子菜单按钮个数"),
    E40024(40024,"不合法的子菜单按钮类型"),
    E40025(40025,"不合法的子菜单按钮名字长度"),
    E40026(40026,"不合法的子菜单按钮 KEY 长度"),
    E40027(40027,"不合法的子菜单按钮 URL 长度"),
    E40028(40028,"不合法的自定义菜单使用用户"),
    E40029(40029,"无效的 oauth_code"),
    E40030(40030,"不合法的 refresh_token"),
    E40031(40031,"不合法的 openid 列表"),
    E40032(40032,"不合法的 openid 列表长度"),
    E40033(40033,"不合法的请求字符，不能包含 \\uxxxx 格式的字符"),
    E40035(40035,"不合法的参数"),
    E40038(40038,"不合法的请求格式"),
    E40039(40039,"不合法的 URL 长度"),
    E40048(40048,"无效的url"),
    E40050(40050,"不合法的分组 id"),
    E40051(40051,"分组名字不合法"),
    E40054(40054,"invalid sub button url domain"),
    E40055(40055,"invalid button url domain"),
    E40060(40060,"删除单篇图文时，指定的 article_idx 不合法"),
    E40066(40066,"invalid url"),
    E40097(40097,"参数错误"),
    E40117(40117,"分组名字不合法"),
    E40118(40118,"media_id 大小不合法"),
    E40119(40119,"button 类型错误"),
    E40120(40120,"子 button 类型错误"),
    E40121(40121,"不合法的 media_id 类型"),
    E40125(40125,"无效的appsecret"),
    E40132(40132,"微信号不合法"),
    E40137(40137,"不支持的图片格式"),
    E40155(40155,"请勿添加其他公众号的主页链接"),
    E40163(40163,"oauth_code已使用"),
    E41001(41001,"缺少 access_token 参数"),
    E41002(41002,"缺少 appid 参数"),
    E41003(41003,"缺少 refresh_token 参数"),
    E41004(41004,"缺少 secret 参数"),
    E41005(41005,"缺少多媒体文件数据"),
    E41006(41006,"缺少 media_id 参数"),
    E41007(41007,"缺少子菜单数据"),
    E41008(41008,"缺少 oauth code"),
    E41009(41009,"缺少 openid"),
    E41010(41010,"missing url"),
    E41030(41030,"所传page页面不存在，或者小程序没有发布"),
    E42001(42001,"access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明"),
    E42002(42002,"refresh_token 超时"),
    E42003(42003,"oauth_code 超时"),
    E42007(42007,"用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权"),
    E43001(43001,"需要 GET 请求"),
    E43002(43002,"需要 POST 请求"),
    E43003(43003,"需要 HTTPS 请求"),
    E43004(43004,"需要接收者关注"),
    E43005(43005,"需要好友关系"),
    E43104(43104, "appid与openid不匹配"),
    E40036(40036,"invalid template_id size"),
    E40037(40037,"invalid template_id"),
    E43019(43019,"需要将接收者从黑名单中移除"),
    E43101(43101,"用户拒绝授权"),
    E44001(44001,"多媒体文件为空"),
    E44002(44002,"POST 的数据包为空"),
    E44003(44003,"图文消息内容为空"),
    E44004(44004,"文本消息内容为空"),
    E44005(44005,"empty list size"),
    E45001(45001,"多媒体文件大小超过限制"),
    E45002(45002,"消息内容超过限制"),
    E45003(45003,"标题字段超过限制"),
    E45004(45004,"描述字段超过限制"),
    E45005(45005,"链接字段超过限制"),
    E45006(45006,"图片链接字段超过限制"),
    E45007(45007,"语音播放时间超过限制"),
    E45008(45008,"图文消息超过限制"),
    E45009(45009,"接口调用超过限制"),
    E45010(45010,"创建菜单个数超过限制"),
    E45011(45011,"API 调用太频繁，请稍候再试"),
    E45012(45012,"template size out of limit"),
    E45015(45015,"回复时间超过限制"),
    E45016(45016,"系统分组，不允许修改"),
    E45017(45017,"分组名字过长"),
    E45018(45018,"分组数量超过上限"),
    E45047(45047,"客服接口下行条数超过上限"),
    E45056(45056,"创建的标签数过多，请注意不能超过100个"),
    E45057(45057,"该标签下粉丝数超过10w，不允许直接删除"),
    E45058(45058,"不能修改0/1/2这三个系统默认保留的标签"),
    E45059(45059,"有粉丝身上的标签数已经超过限制，即超过20个"),
    E45064(45064,"创建菜单包含未关联的小程序"),
    E45065(45065,"相同 clientmsgid 已存在群发记录，返回数据中带有已存在的群发任务的 msgid"),
    E45066(45066,"相同 clientmsgid 重试速度过快，请间隔1分钟重试"),
    E45067(45067,"clientmsgid 长度超过限制"),
    E45157(45157,"标签名非法，请注意不能和其他标签重名"),
    E45158(45158,"标签名长度超过30个字节"),
    E45159(45159,"非法的tag_id"),
    E46001(46001,"不存在媒体数据"),
    E46002(46002,"不存在的菜单版本"),
    E46003(46003,"不存在的菜单数据"),
    E46004(46004,"不存在的用户"),
    E47001(47001,"解析 JSON/XML 内容错误"),
    E48001(48001,"api 功能未授权，请确认公众号已获得该接口，可以在公众平台官网 - 开发者中心页中查看接口权限"),
    E48002(48002,"粉丝拒收消息（粉丝在公众号选项中，关闭了 “ 接收消息 ” ）"),
    E48004(48004,"api 接口被封禁，请登录 mp.weixin.qq.com 查看详情"),
    E48005(48005,"api 禁止删除被自动回复和自定义菜单引用的素材"),
    E48006(48006,"api 禁止清零调用次数，因为清零次数达到上限"),
    E48008(48008,"没有该类型消息的发送权限"),
    E49003(49003,"传入的openid不属于此AppID"),
    E50001(50001,"用户未授权该 api"),
    E50002(50002,"用户受限，可能是违规后接口被封禁"),
    E50005(50005,"用户未关注公众号"),
    E53200(53200,"本月功能介绍修改次数已用完"),
    E53201(53201,"功能介绍内容命中黑名单关键字"),
    E53202(53202,"本月头像修改次数已用完"),
    E53300(53300,"超出每月次数限制"),
    E53301(53301,"超出可配置类目总数限制"),
    E53302(53302,"当前账号主体类型不允许设置此种类目"),
    E53303(53303,"提交的参数不合法"),
    E53304(53304,"与已有类目重复"),
    E53305(53305,"包含未通过 ICP 校验的类目"),
    E53306(53306,"修改类目只允许修改类目资质，不允许修改类目 ID"),
    E53307(53307,"只有审核失败的类目允许修改"),
    E53308(53308,"审核中的类目不允许删除"),
    E61007(61007,"小程序尚未将对应的权限集授权给第三方平台"),
    E61010(61010,"openid超时"),
    E61451(61451,"参数错误 (invalid parameter)"),
    E61452(61452,"无效客服账号 (invalid kf_account)"),
    E61453(61453,"客服帐号已存在 (kf_account exsited)"),
    E61454(61454,"客服帐号名长度超过限制 ( 仅允许 10 个英文字符，不包括 @ 及 @ 后的公众号的微信号 )(invalid   kf_acount length)"),
    E61455(61455,"客服帐号名包含非法字符 ( 仅允许英文 + 数字 )(illegal character in     kf_account)"),
    E61456(61456,"客服帐号个数超过限制 (10 个客服账号 )(kf_account count exceeded)"),
    E61457(61457,"无效头像文件类型 (invalid   file type)"),
    E61450(61450,"系统错误 (system error)"),
    E61500(61500,"日期格式错误"),
    E61501(61501,"时间范围错误"),
    E63001(63001,"部分参数为空"),
    E63002(63002,"无效的签名"),
    E65301(65301,"不存在此 menuid 对应的个性化菜单"),
    E65302(65302,"没有相应的用户"),
    E65303(65303,"没有默认菜单，不能创建个性化菜单"),
    E65304(65304,"MatchRule 信息为空"),
    E65305(65305,"个性化菜单数量受限"),
    E65306(65306,"不支持个性化菜单的帐号"),
    E65307(65307,"个性化菜单信息为空"),
    E65308(65308,"包含没有响应类型的 button"),
    E65309(65309,"个性化菜单开关处于关闭状态"),
    E65310(65310,"填写了省份或城市信息，国家信息不能为空"),
    E65311(65311,"填写了城市信息，省份信息不能为空"),
    E65312(65312,"不合法的国家信息"),
    E65313(65313,"不合法的省份信息"),
    E65314(65314,"不合法的城市信息"),
    E65316(65316,"该公众号的菜单设置了过多的域名外跳（最多跳转到 3 个域名的链接）"),
    E65317(65317,"不合法的 URL"),
    E85006(85006,"标签格式错误"),
    E85007(85007,"页面路径错误"),
    E85008(85008,"当前小程序没有已经审核通过的类目，请添加类目成功后重试"),
    E85009(85009,"已经有正在审核的版本"),
    E85010(85010,"item_list 有项目为空"),
    E85011(85011,"标题填写错误"),
    E85012(85012,"无效的审核 id"),
    E85013(85013,"无效的自定义配置"),
    E85014(85014,"无效的模板编号"),
    E85015(85015,"该账号不是小程序账号"),
    E85016(85016,"域名数量超过限制 ，总数不能超过1000"),
    E85017(85017,"没有新增域名，请确认小程序已经添加了域名或该域名是否没有在第三方平台添加"),
    E85018(85018,"域名没有在第三方平台设置"),
    E85023(85023,"审核列表填写的项目数不在 1-5 以内"),
    E85043(85043,"模板错误"),
    E85044(85044,"代码包超过大小限制"),
    E85045(85045,"ext_json 有不存在的路径"),
    E85046(85046,"tabBar 中缺少 path"),
    E85047(85047,"pages 字段为空"),
    E85048(85048,"ext_json 解析失败"),
    E85051(85051,"version_desc或者preview_info超限"),
    E85064(85064,"找不到草稿"),
    E85065(85065,"模板库已满"),
    E85066(85066,"非法的插件版本"),
    E85067(85067,"找不到使用的插件"),
    E85077(85077,"小程序类目信息失效（类目中含有官方下架的类目，请重新选择类目）"),
    E85082(85082,"没有权限使用该插件"),
    E85085(85085,"小程序提审数量已达本月上限，请点击查看《临时quota申请流程》"),
    E85086(85086,"提交代码审核之前需提前上传代码"),
    E85087(85087,"小程序已使用 api navigateToMiniProgram，请声明跳转 appid 列表后再次提交"),
    E85092(85092,"preview_info格式错误"),
    E85093(85093,"preview_info"),
    E85094(85094,"需提供审核机制说明信息"),
    E86000(86000,"不是由第三方代小程序进行调用"),
    E86001(86001,"不存在第三方的已经提交的代码"),
    E86002(86002,"小程序还未设置昵称、头像、简介。请先设置完后再重新提交"),
    E86007(86007,"小程序禁止提交"),
    E86009(86009,"服务商新增小程序代码提审能力被限制"),
    E86010(86010,"服务商迭代小程序代码提审能力被限制"),
    E87006(87006,"小游戏不能提交"),
    E87009(87009,"无效的签名"),
    E87011(87011,"现网已经在灰度发布，不能进行版本回退"),
    E87012(87012,"该版本不能回退，可能的原因：1:无上一个线上版用于回退 2:此版本为已回退版本，不能回退 3:此版本为回退功能上线之前的版本，不能回退"),
    E87013(87013,"撤回次数达到上限（每天5次，每个月 10 次）"),
    E89021(89021,"业务域名需经过ICP备案"),
    E89401(80401,"系统不稳定，请稍后再试，如多次失败请通过社区反馈"),
    E89402(80402,"该审核单不在待审核队列，请检查是否已提交审核或已审完"),
    E89403(80403,"本单属于平台不支持加急种类，请等待正常审核流程"),
    E89404(80404,"本单已加速成功，请勿重复提交"),
    E89405(80405,"本月加急额度不足，请提升提审质量以获取更多额度"),
    E85052(85052,"app已发布"),
    E200011(200011,"此账号已被封禁，无法操作"),
    E200012(200012,"个人模版数已达上限，上限25个"),
    E200013(200013,"此模版已被封禁，无法选用"),
    E200014(200014,"模版 tid 参数错误"),
    E200016(200016,"start 参数错误"),
    E200017(200017,"limit 参数错误"),
    E200018(200018,"类目 ids 缺失"),
    E200019(200019,"类目 ids 不合法"),
    E200020(200020,"关键词列表 kidList 参数错误"),
    E200021(200021,"场景描述 sceneDesc 参数错误"),
    E200022(200022,"订阅消息模版已添加"),
    E9001001(9001001,"POST 数据参数不合法"),
    E9001002(9001002,"远端服务不可用"),
    E9001003(9001003,"Ticket 不合法"),
    E9001004(9001004,"获取摇周边用户信息失败"),
    E9001005(9001005,"获取商户信息失败"),
    E9001006(9001006,"获取 OpenID 失败"),
    E9001007(9001007,"上传文件缺失"),
    E9001008(9001008,"上传素材的文件类型不合法"),
    E9001009(9001009,"上传素材的文件尺寸不合法"),
    E9001010(9001010,"上传失败"),
    E9001020(9001020,"帐号不合法"),
    E9001021(9001021,"已有设备激活率低于 50% ，不能新增设备"),
    E9001022(9001022,"设备申请数不合法，必须为大于 0 的数字"),
    E9001023(9001023,"已存在审核中的设备 ID 申请"),
    E9001024(9001024,"一次查询设备 ID 数量不能超过 50"),
    E9001025(9001025,"设备 ID 不合法"),
    E9001026(9001026,"页面 ID 不合法"),
    E9001027(9001027,"页面参数不合法"),
    E9001028(9001028,"一次删除页面 ID 数量不能超过 10"),
    E9001029(9001029,"页面已应用在设备中，请先解除应用关系再删除"),
    E9001030(9001030,"一次查询页面 ID 数量不能超过 50"),
    E9001031(9001031,"时间区间不合法"),
    E9001032(9001032,"保存设备与页面的绑定关系参数错误"),
    E9001033(9001033,"门店 ID 不合法"),
    E9001034(9001034,"设备备注信息过长"),
    E9001035(9001035,"设备申请参数不合法"),
    E9001036(9001036,"查询起始值 begin 不合法"),

    ;

    private Integer errorCode;
    private String desc;
    WxErrorCodeEnum(Integer errorCode,String desc){
        this.errorCode = errorCode;
        this.desc = desc;
    }

    public static WxErrorCodeEnum getByErrorCode(Integer errorCode){
        for(WxErrorCodeEnum wxErrorCodeEnum : WxErrorCodeEnum.values()){
            if(wxErrorCodeEnum.getErrorCode().equals(errorCode)){
                return wxErrorCodeEnum;
            }
        }
        return WxErrorCodeEnum.E_10000;
    }
}
