package cn.com.duiba.wechat.server.api.dto.templatepush;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PushRecordDTO implements Serializable {

    private static final long serialVersionUID = -9020286325249010581L;

    /**
     * 推送时间
     */
    private Date gmtCreate;

    /**
     * 推送名称
     */
    private String pushName;

    /**
     * 推送场景
     */
    private Integer pushScene;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * openid
     */
    private String openId;

    private Long msgId;

    private Long bizId;

    private Long configId;

    /**
     * 所属定时任务ID
     */
    private Long taskId;

    /**
     * 推送状态 1:“成功”、2:“失败”、3:“拒收”
     */
    private Integer pushStatue;

    private String errorCode;

    private String errorDesc;
}
