package cn.com.duiba.wechat.server.api.param.menu;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 公众号菜单
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/26 3:44 下午
 **/
@Data
public class MenuParam implements Serializable {

    private static final long serialVersionUID = 1565856447214654027L;
    /**
     * 是
     * 一级菜单数组，个数应为1~3个
     */
    private List<MenuParam> button;

    /**
     * 否
     * 二级菜单数组，个数应为1~5个
     */
    private List<MenuParam> subButton;

    /**
     * 是
     * 菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
     */
    private String type;

    /**
     * 是
     * 菜单标题，不超过16个字节，子菜单不超过60个字节
     */
    private String name;

    /**
     * click等点击类型必须	菜单KEY值，用于消息接口推送，不超过128字节
     */
    private String key;

    /**
     * view、miniprogram类型必须
     * 网页 链接，用户点击菜单可打开链接，不超过1024字节。 type为miniprogram时，不支持小程序的老版本客户端将打开本url。
     */
    private String url;

    /**
     * media_id类型和view_limited类型必须
     * 调用新增永久素材接口返回的合法media_id
     */
    @JSONField(name = "media_id")
    private String mediaId;

    /**
     * miniprogram类型必须
     * 小程序的appid（仅认证公众号可配置）
     */
    private String appid;

    /**
     * miniprogram类型必须
     * 小程序的页面路径
     */
    private String pagepath;

    /**
     * article_id类型和article_view_limited类型必须
     * 发布后获得的合法 article_id
     */
    @JSONField(name = "article_id")
    private String articleId;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 文本信息
     */
    private String text;

}
