package cn.com.duiba.wechat.server.api.param.templatepush;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateParam implements Serializable {

    private static final long serialVersionUID = 1567982860927721565L;
    private String user;
    private String phone;
    private String activityName;
    private String awardName;
    private Date awardDeadline;
    private Date awardTime;
    private String expressCompany;
    private String orderId;
    private String expressNum;
    private Long bizId;
    @NotNull(message = "openId不能为空")
    private String openId;
    /**
     * 推送场景 {@link PushScenesEnum}
     */
    @NotNull(message = "推送场景不能为空")
    private Integer pushScene;
}
