package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.material.DraftDto;
import cn.com.duiba.wechat.server.api.dto.material.MaterialDto;
import cn.com.duiba.wechat.server.api.dto.material.SendAllDto;
import cn.com.duiba.wechat.server.api.dto.material.SendAllStatusDto;
import cn.com.duiba.wechat.server.api.dto.tag.WxBaseDto;
import cn.com.duiba.wechat.server.api.param.material.DraftQueryParam;
import cn.com.duiba.wechat.server.api.param.material.MaterialPreviewParam;
import cn.com.duiba.wechat.server.api.param.material.MaterialQueryParam;
import cn.com.duiba.wechat.server.api.param.material.MediaSingleQueryParam;
import cn.com.duiba.wechat.server.api.param.material.QuerySendAllStatusParam;
import cn.com.duiba.wechat.server.api.param.material.SendAllParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author wangxukai
 * @description 素材接口
 * @date ：Created in 2022/1/10
 */
@AdvancedFeignClient
public interface RemoteWxMaterialService {

    /**
     * 查询素材列表
     * @param param
     * @return
     */
    PageResponse<MaterialDto> getMaterialList(MaterialQueryParam param);

    /**
     * 查询草稿列表
     * @param param
     * @return
     */
    PageResponse<DraftDto> getDraftList(DraftQueryParam param);

    /**
     * 素材预览
     * @param param
     * @return
     */
    WxBaseDto materialPreview(MaterialPreviewParam param);

    /**
     * 群发
     * @param param
     * @return
     */
    SendAllDto sendAll(SendAllParam param);

    /**
     * 查询群发状态
     * @param param
     * @return
     */
    SendAllStatusDto querySendAllStatus(QuerySendAllStatusParam param);

    /**
     * 查询素材id是否存在
     * @param param
     * @return
     */
    WxBaseDto queryMediaExist(MediaSingleQueryParam param);
}
