package cn.com.duiba.wechat.server.api.constant;

import static cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum.TIMING;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import cn.com.duiba.wechat.server.api.dto.templatepush.TemplateParameterDTO;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;

/**
 * @author xuanhongjian
 */
@Slf4j
public class SceneParamConstants {

    /**
     * 存放每个场景的可用变量
     */
    private static final ImmutableMap<Integer, Map<String, String>> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, Map<String, String>> builder = ImmutableMap.builder();
        Map<String, String> prizeNotice = Maps.newHashMap();
        prizeNotice.put("{user}", "getUser");
        prizeNotice.put("{phone}", "getPhone");
        prizeNotice.put("{activity}", "getActivityName");
        prizeNotice.put("{award}", "getAwardName");
        prizeNotice.put("{award_time}", "getAwardTime");
        prizeNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.PRIZE_NOTICE.getCode(), prizeNotice);
        Map<String, String> expiredNotice = Maps.newHashMap();
        expiredNotice.put("{user}", "getUser");
        expiredNotice.put("{phone}", "getPhone");
        expiredNotice.put("{activity}", "getActivityName");
        expiredNotice.put("{award}", "getAwardName");
        expiredNotice.put("{award_time}", "getAwardTime");
        expiredNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.EXPIRED_NOTICE.getCode(), expiredNotice);
        Map<String, String> shipNotice = Maps.newHashMap();
        shipNotice.put("{user}", "getUser");
        shipNotice.put("{phone}", "getPhone");
        shipNotice.put("{activity}", "getActivityName");
        shipNotice.put("{award}", "getAwardName");
        shipNotice.put("{award_time}", "getAwardTime");
        shipNotice.put("{award_deadline}", "getAwardDeadline");
        shipNotice.put("{express_company}", "getExpressCompany");
        shipNotice.put("{express_num}", "getExpressNum");
        shipNotice.put("{order_id}", "getOrderId");
        shipNotice.put("{delivery_time}","getDeliveryTime");
        builder.put(PushScenesEnum.SHIP_NOTICE.getCode(), shipNotice);
        //定时任务提醒参数
        Map<String, String> timingNotice = Maps.newHashMap();
        timingNotice.put("{user}", "getUser");
        timingNotice.put("{phone}", "getPhone");
        builder.put(TIMING.getCode(), timingNotice);
        INNER_MAP = builder.build();
    }

    /**
     *
     * @param code 场景值
     * @param paramName 参数名称
     * @param dto 模版参数值
     * @return 实际值
     */
    public static String getValue(Integer code,String paramName,TemplateParameterDTO dto) {
        Map<String, String> map = INNER_MAP.get(code);
        if(MapUtils.isEmpty(map)){
            return paramName;
        }
        Class<?> aClass = dto.getClass();
        for (Map.Entry<String, String> entry:map.entrySet()) {
            String key = entry.getKey();
            if(paramName.contains(key)){
                try {
                    Method declaredMethod = aClass.getDeclaredMethod(entry.getValue());
                    Object invoke = declaredMethod.invoke(dto);
                    if(invoke!=null){
                        paramName = paramName.replaceAll(String.format("\\%s", key),invoke.toString());
                    }
                }catch (Exception e){
                    log.error("替换用户变量异常",e);
                }
            }
        }
      return paramName;
    }
}
