package cn.com.duiba.wechat.server.api.constant.enums;

import lombok.Getter;

/**
 * 消息类型枚举
 *
 * @author zouweixiang
 * @date 2021/11/28
 */
@Getter
public enum MessageTypeEnum {

    /**
     * 状态码
     */
    TEXT(1, "文本"),

    IMAGE(2, "图片消息"),

    VOICE(3, "语音消息"),

    VIDEO(4, "视频消息"),

    SHORTVIDEO(5, "小视频消息"),

    LOCATION(6, "地理位置消息"),

    LINK(7, "链接消息"),
    ;


    /**
     * 枚举值
     */
    private final int code;

    /**
     * 枚举描述
     */
    private final String desc;


    MessageTypeEnum(final int code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

}
