package cn.com.duiba.wechat.server.api.param.groupsendtask;

import cn.com.duiba.wolf.entity.PageRequest;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class PageQueryParam extends PageRequest {

    private static final long serialVersionUID = 7777030782525531009L;

    /**
     * 任务ID
     */
    private Long id;

    /**
     * 素材ID
     */
    private String mediaId;

    /**
     * 素材标题
     */
    private String mediaName;

    /**
     * 群发类型 1:立即群发，2：定时群发
     */
    private Integer sendType;

    /**
     * 群发时间 开始时间
     */
    private Date sendStartDate;

    /**
     * 群发时间 结束时间
     */
    private Date sendEndDate;

    /**
     * 任务状态
     */
    private Integer taskStatue;

    /**
     * 创建时间
     */
    private Date createStartDate;
    private Date createEndDate;
}
