package cn.com.duiba.wechat.server.api.param.manualpush;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateManualPushParam implements Serializable {

    private static final long serialVersionUID = 3530885801027132092L;

    @NotNull(message = "ID不能为空")
    private Long id;

    @Size(max = 50, message = "推送名称最大50个字符")
    private String pushName;

    /**
     * 1:立即推送，2：定时推送
     */
    private Integer pushType;

    /**
     * 推送时间
     */
    private Date pushDate;


    private Integer pushRange;


    /**
     * 用户限制 1. 全部用户 2:仅零售户
     */
    private Integer pushLimit;

    /**
     * '地区限制'
     */
    private String province;

    private String city;

    private String district;

    /**
     * 标签ID
     */
    private List<Long> tags;

    /**
     * 模版ID
     */
    private String templateId;

    /**
     * 模版参数映射
     */
    private JSONObject paramConfig;

    /**
     * 跳转url
     */
    private String url;

    /**
     * 测试人员
     */
    private String testUser;
}
