package cn.com.duiba.wechat.server.api.param.material;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/1/12
 */
@Data
public class SendAllParam implements Serializable {

    @JSONField(name = "msgtype")
    private String msgType;

    @JSONField(name = "mpnews")
    private MpNews mpNews;

    @JSONField(name = "voice")
    private MpNews voice;

    @JSONField(name = "images")
    private Image image;

    @JSONField(name = "mpvideo")
    private MpNews mpVideo;

    @JSONField(name = "text")
    private Text text;

    @JSONField(name = "send_ignore_reprint")
    private Integer sendIgnoreReprint;

    /**
     * 按标签发送
     */
    @JSONField(name = "filter")
    private Filter filter;

    /**
     * 按openId列表发送
     */
    @JSONField(name = "touser")
    private List<String> toUserList;


    @Data
    public static class  MpNews implements Serializable{
        @JSONField(name = "media_id")
        private String mediaId;
    }
    @Data
    public static class Text implements Serializable{
        @JSONField(name = "content")
        private String content;
    }
    @Data
    public static class Image implements Serializable{
        @JSONField(name = "recommend")
        private String recommend;
        @JSONField(name = "need_open_comment")
        private Integer needOpenComment;
        @JSONField(name = "only_fans_can_comment")
        private Integer onlyFansCanComment;
        @JSONField(name = "media_ids")
        private List<String> mediaIds;

    }



    @Data
    public static class Filter implements Serializable{
        @JSONField(name = "is_to_all")
        private Boolean isToAll;
        @JSONField(name = "tag_id")
        private Integer tagId;

    }
}
