package cn.com.duiba.wechat.server.api.param.templatepush;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 创建自动推送配置
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateAutoPushConfigParam implements Serializable {

    private static final long serialVersionUID = 8290747703548810177L;

    @NotNull(message = "模版ID不能为空")
    private Long id;
    /**
     * 推送名称
     */
    private String pushName;


    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 模版ID
     */
    private String templateId;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 参数配置
     */
    private JSONObject paramConfig;

    /**
     * 提前多少小时通知
     */
    private Integer warningHour;

    /**
     * 编辑人
     */
    @NotBlank(message = "修改人不能为空")
    private String modifiedBy;
}
