package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.templatepush.AutoPushConfigDTO;
import cn.com.duiba.wechat.server.api.param.templatepush.CreateAutoPushConfigParam;
import cn.com.duiba.wechat.server.api.param.templatepush.PageQueryParam;
import cn.com.duiba.wechat.server.api.param.templatepush.PushIdParam;
import cn.com.duiba.wechat.server.api.param.templatepush.UpdateAutoPushConfigParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 自动推送配置管理
 *
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemotePushConfigService {

    /**
     * 新增自动推送配置
     * @param param 参数
     * @return 主键ID
     * @throws BizException 业务异常
     */
    Long createAutoPushConfig(CreateAutoPushConfigParam param) throws BizException;

    /**
     * 分页查询自动推送配置
     *
     * @param pageQueryParam 查询参数
     * @return 分页数据
     */
    PageResponse<AutoPushConfigDTO> pageQuery(PageQueryParam pageQueryParam);

    /**
     * 根据id查询配置
     *
     * @param pushIdParam ID
     * @return 自动推送配置
     */
    AutoPushConfigDTO getById(PushIdParam pushIdParam);

    /**
     * 更新自动配置
     *
     * @param pushConfigParam 自动配置参数
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean updateAutoPushConfig(UpdateAutoPushConfigParam pushConfigParam) throws BizException;
}
