package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.tag.TagAddDto;
import cn.com.duiba.wechat.server.api.dto.tag.TagListDto;
import cn.com.duiba.wechat.server.api.dto.tag.TagUserDto;
import cn.com.duiba.wechat.server.api.dto.tag.WxBaseDto;
import cn.com.duiba.wechat.server.api.param.tag.WxTagAddParam;
import cn.com.duiba.wechat.server.api.param.tag.WxTagBatchTagParam;
import cn.com.duiba.wechat.server.api.param.tag.WxTagDelParam;
import cn.com.duiba.wechat.server.api.param.tag.WxTagEditParam;
import cn.com.duiba.wechat.server.api.param.tag.WxTagListParam;

/**
 * 微信标签服务
 *
 * @author xiaotian
 * @date 2021/11/24
 */
@AdvancedFeignClient
public interface RemoteWxTagService {

    /**
     * 通过accessToken获取公众号已创建的标签
     *
     * @param wechatAppid 访问令牌
     * @return {@link TagListDto}
     */
    TagListDto getTags(String wechatAppid);

    /**
     * 创建标签
     *
     * @param tagAddParam 参数
     * @return {@link TagAddDto}
     */
    TagAddDto addTag(WxTagAddParam tagAddParam);

    /**
     * 编辑标签
     *
     * @param tagEditParam 参数
     * @return {@link WxBaseDto}
     */
    WxBaseDto editTag(WxTagEditParam tagEditParam);


    /**
     * 删除标签
     *
     * @param tagDelParam 参数
     * @return {@link WxBaseDto}
     */
    WxBaseDto delTag(WxTagDelParam tagDelParam);


    /**
     * 获取标签下粉丝列表
     *
     * @param tagListParam 参数
     * @return {@link TagUserDto}
     */
    TagUserDto tagUserList(WxTagListParam tagListParam);


    /**
     * 批量为用户打标签
     *
     * @param tagBatchTagParam 参数
     * @return {@link WxBaseDto}
     */
    WxBaseDto batchTag(WxTagBatchTagParam tagBatchTagParam);


    /**
     * 批量为用户取消标签
     *
     * @param tagBatchTagParam 参数
     * @return {@link WxBaseDto}
     */
    WxBaseDto batchUnTag(WxTagBatchTagParam tagBatchTagParam);
}
