package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.constant.enums.WxPushMsgTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutImageMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutVideoMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutVoiceMessage;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/8 16:20
 */
@Getter
@Setter
@ToString
public class AutoRespInfoDTO implements Serializable {

    /**
     * 推送类型
     * @see WxPushMsgTypeEnum#TEXT
     * @see WxPushMsgTypeEnum#IMAGE
     * @see WxPushMsgTypeEnum#IMG
     * @see WxPushMsgTypeEnum#VOICE
     * @see WxPushMsgTypeEnum#VIDEO
     */
    private WxPushMsgTypeEnum pushMsgType;

    /**
     * 文本消息
     */
    private WxMpXmlOutTextMessage text;

    /**
     * 图片消息
     */
    private WxMpXmlOutImageMessage image;

    /**
     * 语音消息
     */
    private WxMpXmlOutVoiceMessage voice;

    /**
     * 视频消息
     */
    private WxMpXmlOutVideoMessage video;

    /**
     * 图文消息
     */
    private WxMpXmlOutNewsMessage news;
}
