package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.enums.LogoTypeEnum;
import cn.com.duiba.wechat.server.api.enums.QrCodeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/12 19:39
 */
@Getter
@Setter
@ToString
public class WechatQrcodeDetailDTO implements Serializable {

    /**
     * 二维码ID
     */
    private Long id;

    /**
     * 场景名称
     */
    private String name;

    /**
     * 微信二维码类型, 0 临时码，1 永久码，默认 0
     *
     * @see QrCodeTypeEnum
     */
    private Integer type;

    /**
     * 有效期，单位小时
     */
    private Integer validTime;

    /**
     * logo url
     */
    private String logo;

    /**
     * logo类型, 0 无logo, 1 使用公众号头像, 2 自定义图片，默认 0
     *
     * @see LogoTypeEnum
     */
    private Integer logoType;

    /**
     * 是否开启扫码粉丝打标, 默认不开启
     */
    private Boolean mark;

    /**
     * 是否开启扫码后自动回复, 默认不开启
     */
    private Boolean autoResp;

    /**
     * 扩展信息，包含打标 list, 回复内容list
     * @see WxQrcodeExtraDTO
     */
    private List<WxQrcodeExtraDTO> extraList;
}
