package cn.com.duiba.wechat.server.api.param.groupsendtask;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 群发任务创建
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CreateGroupSendTaskParam implements Serializable {

    private static final long serialVersionUID = 2438225444472253762L;
    /**
     * 素材ID
     */
    @NotNull(message = "素材ID不能为空")
    private String mediaId;

    /**
     * 素材标题不能为空
     */
    @NotNull(message = "素材名称不能为空")
    private String mediaName;

    @NotNull(message = "素材类型不能为空")
    private Integer materialType;

    /**
     * 1:立即群发，2：定时群发
     */
    @NotNull(message = "群发类型不能为空")
    private Integer sendType;

    /**
     * '发送时间'
     */
    private Date sendTime;

    /**
     * 群发范围 1:全部，2:定向
     */
    @NotNull(message = "群发范围不能为空")
    private Integer sendRange;

    /**
     * 用户限制 1. 全部用户 2:仅零售户
     */
    @NotNull(message = "用户限制不能为空")
    private Integer userLimit;

    /**
     * '地区限制'
     */
    private String province;

    private String city;

    private String district;

    /**
     * 标签ID
     */
    private List<Long> tags;

    /**
     * 测试人员
     */
    private String testUser;

    /**
     * 创建人
     */
    @NotNull(message = "创建人不能为空")
    private String innerUserId;
}
