package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.enums.DataStaticsEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/13 11:24
 */
@Getter
@Setter
public class RemoteQrcodeDataTrendParam implements Serializable {

    /**
     * 二维码ID
     */
    private Long id;

    /**
     * 统计开始时间
     */
    @NotNull(message = "统计开始时间不能为空")
    private Long startTime;

    /**
     * 统计结束时间
     */
    @NotNull(message = "统计结束时间不能为空")
    private Long endTime;

    /**
     * 类型
     * @see DataStaticsEnum
     */
    @NotNull(message = "类型不能为空")
    private Integer type;
}
