package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/1/14
 */
@Getter
public enum SendAllErrorCodeEnum {
    SUCCESS("send success","成功"),
    FAIL("send fail","发送失败"),
    ERR10001("err(10001)","涉嫌广告"),
    ERR20001("err(20001)","涉嫌政治"),
    ERR20004("err(20004)","涉嫌社会"),
    ERR20002("err(20002)","涉嫌色情"),
    ERR20006("err(20006)","涉嫌违法犯罪"),
    ERR20008("err(20008)","涉嫌欺诈"),
    ERR20013("err(20013)","涉嫌版权"),
    ERR22000("err(22000)","涉嫌互推(互相宣传)"),
    ERR21000("err(21000)","涉嫌其他"),
    ERR30001("err(30001)","原创校验出现系统错误且用户选择了被判为转载就不群发"),
    ERR30002("err(30002)","原创校验被判定为不能群发"),
    ERR30003("err(30003)","原创校验被判定为转载文且用户选择了被判为转载就不群发"),
    ERR40001("err(40001)","管理员拒绝"),
    ERR40002("err(40002)","管理员30分钟内无响应，超时"),
    BIZ_ERR("BIZ_ERR(00001)","素材不存在"),
    UNKNOWN_ERROR("","未知错误")
    ;


    private static final ImmutableMap<String, SendAllErrorCodeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, SendAllErrorCodeEnum> builder = ImmutableMap.builder();
        for (SendAllErrorCodeEnum item : SendAllErrorCodeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }
    private String code;

    private String desc;
    SendAllErrorCodeEnum(String code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code){
        for(SendAllErrorCodeEnum sendAllErrorCodeEnum : SendAllErrorCodeEnum.values()){
            if(sendAllErrorCodeEnum.getCode().equals(code)){
                return sendAllErrorCodeEnum.getDesc();
            }
        }
        return "未知情况";
    }

    public static SendAllErrorCodeEnum getByCode(String code) {
        return Objects.isNull(code) ? UNKNOWN_ERROR
                   : (INNER_MAP.get(code) == null ? UNKNOWN_ERROR : INNER_MAP.get(code));
    }

}
