package cn.com.duiba.wechat.server.api.constant.enums;


import java.util.HashMap;
import java.util.Map;

/**
 * 事件类型
 * @author zouweixiang
 * @date 2021/11/26
 */
public enum WxEventTypeEnum {
    /**
     * 事件类型
     */
    EVENT_SUBSCRIBE("subscribe", "关注事件"),
    EVENT_UNSUBSCRIBE("unsubscribe", "取关事件"),
    EVENT_SCAN("SCAN", "扫描带参数二维码事件（已关注用户）"),
    EVENT_LOCATION("LOCATION", "上报地理位置事件"),
    EVENT_CLICK("CLICK", "自定义菜单事件"),
    EVENT_VIEW("VIEW", "点击菜单跳转链接时的事件推送"),
    MESSAGE_END_JOB_FINISH("MASSSENDJOBFINISH", "事件推送群发结果"),
    TEMPLATE_SEND_JOB_FINISH("TEMPLATESENDJOBFINISH","模版消息推送"),
    VIEW_MINIPROGRAM("view_miniprogram","微信小程序"),
    MINIPROGRAM("miniprogram","微信小程序"),
    ;

    private String msgType;

    private String desc;

    WxEventTypeEnum(String msgType, String desc) {
        this.msgType = msgType;
        this.desc = desc;
    }

    private static final Map<String, WxEventTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxEventTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getMsgType(), tmp);
        }
    }

    public static WxEventTypeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getMsgType() {
        return msgType;
    }

    public String getDesc() {
        return desc;
    }
}
