package cn.com.duiba.wechat.server.api.dto.material;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/1/11
 */
@Data
public class DraftDto implements Serializable {
    /**
     * 媒体id
     */
    private String mediaId;
    /**
     * 更新时间
     */
    private Integer updateTime;
    /**
     * 内容
     */
    private DraftContentDto content;

    @Getter
    @Setter
    public static class DraftContentDto implements Serializable{
        @JSONField(name = "news_item")
        private List<DraftNewsItemDto> itemList;
        @Getter
        @Setter
        public static class DraftNewsItemDto implements Serializable{
            @JSONField(name = "title")
            private String title;
            @JSONField(name = "author")
            private String author;
            @JSONField(name = "digest")
            private String digest;
            @JSONField(name = "content")
            private String content;
            @JSONField(name = "content_source_url")
            private String contentSourceUrl;
            @JSONField(name = "thumb_media_id")
            private String thumbMediaId;
            @JSONField(name = "show_cover_pic")
            private Integer showCoverPic;
            @JSONField(name = "need_open_comment")
            private Integer needOpenComment;
            @JSONField(name = "only_fans_can_comment")
            private Integer onlyFansCanComment;
            @JSONField(name = "url")
            private String url;
        }
    }
}
